function plot_all(dataMathematics,dataPhysics,planta)

%{

 This function makes a plot of all the building with all the diferent
 elements. The arguments of this function are:
   
    dataPhysics -> Object with all the model information
    planta -> An integer showing the floor that must be plot
       -1  -> All the building
        0  -> Planta baja
        1  -> First Floor
        2  -> Second Floor

 Fernando Jess Aranda Polo 
 Last change:
 1/03/2020

%}


if (planta == -1)

       axis([-10 100 -5 200 -10 12])
    
    % PintdataPhysics.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=1:1:dataPhysics.finPlantaBaja 
        % Lnea 1 (abajo)
        X1 = [X1 dataPhysics.wall(j).p1(1)];
        X2 = [X2 dataPhysics.wall(j).p2(1)];
        Y1 = [Y1 dataPhysics.wall(j).p1(2)];
        Y2 = [Y2 dataPhysics.wall(j).p2(2)];
        Z1 = [Z1 dataPhysics.wall(j).p1(3)];
        Z2 = [Z2 dataPhysics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataPhysics.wall(j).p2(1)];
        X2 = [X2 dataPhysics.wall(j).p3(1)];
        Y1 = [Y1 dataPhysics.wall(j).p2(2)];
        Y2 = [Y2 dataPhysics.wall(j).p3(2)];
        Z1 = [Z1 dataPhysics.wall(j).p2(3)];
        Z2 = [Z2 dataPhysics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataPhysics.wall(j).p3(1)];
        X2 = [X2 dataPhysics.wall(j).p4(1)];
        Y1 = [Y1 dataPhysics.wall(j).p3(2)];
        Y2 = [Y2 dataPhysics.wall(j).p4(2)];
        Z1 = [Z1 dataPhysics.wall(j).p3(3)];
        Z2 = [Z2 dataPhysics.wall(j).p4(3)];

        % Lnea 1 (haca abajo)
        X1 = [X1 dataPhysics.wall(j).p4(1)];
        X2 = [X2 dataPhysics.wall(j).p1(1)];
        Y1 = [Y1 dataPhysics.wall(j).p4(2)];
        Y2 = [Y2 dataPhysics.wall(j).p1(2)];
        Z1 = [Z1 dataPhysics.wall(j).p4(3)];
        Z2 = [Z2 dataPhysics.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on


    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=dataPhysics.finPlantaBaja+1:1:dataPhysics.finPrimeraPlanta 
        % Lnea 1 (abajo)
        X1 = [X1 dataPhysics.wall(j).p1(1)];
        X2 = [X2 dataPhysics.wall(j).p2(1)];
        Y1 = [Y1 dataPhysics.wall(j).p1(2)];
        Y2 = [Y2 dataPhysics.wall(j).p2(2)];
        Z1 = [Z1 dataPhysics.wall(j).p1(3)];
        Z2 = [Z2 dataPhysics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataPhysics.wall(j).p2(1)];
        X2 = [X2 dataPhysics.wall(j).p3(1)];
        Y1 = [Y1 dataPhysics.wall(j).p2(2)];
        Y2 = [Y2 dataPhysics.wall(j).p3(2)];
        Z1 = [Z1 dataPhysics.wall(j).p2(3)];
        Z2 = [Z2 dataPhysics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataPhysics.wall(j).p3(1)];
        X2 = [X2 dataPhysics.wall(j).p4(1)];
        Y1 = [Y1 dataPhysics.wall(j).p3(2)];
        Y2 = [Y2 dataPhysics.wall(j).p4(2)];
        Z1 = [Z1 dataPhysics.wall(j).p3(3)];
        Z2 = [Z2 dataPhysics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataPhysics.wall(j).p4(1)];
        X2 = [X2 dataPhysics.wall(j).p1(1)];
        Y1 = [Y1 dataPhysics.wall(j).p4(2)];
        Y2 = [Y2 dataPhysics.wall(j).p1(2)];
        Z1 = [Z1 dataPhysics.wall(j).p4(3)];
        Z2 = [Z2 dataPhysics.wall(j).p1(3)];    
    end

        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','r','MarkerSize',30);
        hold on


    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=dataPhysics.finPrimeraPlanta+1:1:dataPhysics.finSegundaPlanta 
        % Lnea 1 (abajo)
        X1 = [X1 dataPhysics.wall(j).p1(1)];
        X2 = [X2 dataPhysics.wall(j).p2(1)];
        Y1 = [Y1 dataPhysics.wall(j).p1(2)];
        Y2 = [Y2 dataPhysics.wall(j).p2(2)];
        Z1 = [Z1 dataPhysics.wall(j).p1(3)];
        Z2 = [Z2 dataPhysics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataPhysics.wall(j).p2(1)];
        X2 = [X2 dataPhysics.wall(j).p3(1)];
        Y1 = [Y1 dataPhysics.wall(j).p2(2)];
        Y2 = [Y2 dataPhysics.wall(j).p3(2)];
        Z1 = [Z1 dataPhysics.wall(j).p2(3)];
        Z2 = [Z2 dataPhysics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataPhysics.wall(j).p3(1)];
        X2 = [X2 dataPhysics.wall(j).p4(1)];
        Y1 = [Y1 dataPhysics.wall(j).p3(2)];
        Y2 = [Y2 dataPhysics.wall(j).p4(2)];
        Z1 = [Z1 dataPhysics.wall(j).p3(3)];
        Z2 = [Z2 dataPhysics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataPhysics.wall(j).p4(1)];
        X2 = [X2 dataPhysics.wall(j).p1(1)];
        Y1 = [Y1 dataPhysics.wall(j).p4(2)];
        Y2 = [Y2 dataPhysics.wall(j).p1(2)];
        Z1 = [Z1 dataPhysics.wall(j).p4(3)];
        Z2 = [Z2 dataPhysics.wall(j).p1(3)];    
    end

        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','g','MarkerSize',30);
        hold on
        
      X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=dataPhysics.finSegundaPlanta +1:1:dataPhysics.fincosas 
        % Lnea 1 (abajo)
        X1 = [X1 dataPhysics.wall(j).p1(1)];
        X2 = [X2 dataPhysics.wall(j).p2(1)];
        Y1 = [Y1 dataPhysics.wall(j).p1(2)];
        Y2 = [Y2 dataPhysics.wall(j).p2(2)];
        Z1 = [Z1 dataPhysics.wall(j).p1(3)];
        Z2 = [Z2 dataPhysics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataPhysics.wall(j).p2(1)];
        X2 = [X2 dataPhysics.wall(j).p3(1)];
        Y1 = [Y1 dataPhysics.wall(j).p2(2)];
        Y2 = [Y2 dataPhysics.wall(j).p3(2)];
        Z1 = [Z1 dataPhysics.wall(j).p2(3)];
        Z2 = [Z2 dataPhysics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataPhysics.wall(j).p3(1)];
        X2 = [X2 dataPhysics.wall(j).p4(1)];
        Y1 = [Y1 dataPhysics.wall(j).p3(2)];
        Y2 = [Y2 dataPhysics.wall(j).p4(2)];
        Z1 = [Z1 dataPhysics.wall(j).p3(3)];
        Z2 = [Z2 dataPhysics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataPhysics.wall(j).p4(1)];
        X2 = [X2 dataPhysics.wall(j).p1(1)];
        Y1 = [Y1 dataPhysics.wall(j).p4(2)];
        Y2 = [Y2 dataPhysics.wall(j).p1(2)];
        Z1 = [Z1 dataPhysics.wall(j).p4(3)];
        Z2 = [Z2 dataPhysics.wall(j).p1(3)];    
    end

    plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','k','MarkerSize',30);
    hold on
    
    hold on
    plot3(dataPhysics.pE1(:,1),dataPhysics.pE1(:,2),dataPhysics.pE1(:,3),'color','K','MarkerSize',10);
    hold on
 
    
    % PintdataMathematics.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];


    for j=1:1:dataMathematics.finPlantaBaja 
        % Lnea 1 (abajo)
        X1 = [X1 dataMathematics.wall(j).p1(1)];
        X2 = [X2 dataMathematics.wall(j).p2(1)];
        Y1 = [Y1 dataMathematics.wall(j).p1(2)];
        Y2 = [Y2 dataMathematics.wall(j).p2(2)];
        Z1 = [Z1 dataMathematics.wall(j).p1(3)];
        Z2 = [Z2 dataMathematics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataMathematics.wall(j).p2(1)];
        X2 = [X2 dataMathematics.wall(j).p3(1)];
        Y1 = [Y1 dataMathematics.wall(j).p2(2)];
        Y2 = [Y2 dataMathematics.wall(j).p3(2)];
        Z1 = [Z1 dataMathematics.wall(j).p2(3)];
        Z2 = [Z2 dataMathematics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataMathematics.wall(j).p3(1)];
        X2 = [X2 dataMathematics.wall(j).p4(1)];
        Y1 = [Y1 dataMathematics.wall(j).p3(2)];
        Y2 = [Y2 dataMathematics.wall(j).p4(2)];
        Z1 = [Z1 dataMathematics.wall(j).p3(3)];
        Z2 = [Z2 dataMathematics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataMathematics.wall(j).p4(1)];
        X2 = [X2 dataMathematics.wall(j).p1(1)];
        Y1 = [Y1 dataMathematics.wall(j).p4(2)];
        Y2 = [Y2 dataMathematics.wall(j).p1(2)];
        Z1 = [Z1 dataMathematics.wall(j).p4(3)];
        Z2 = [Z2 dataMathematics.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on


    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=dataMathematics.finPlantaBaja+1:1:dataMathematics.finPrimeraPlanta 
        % Lnea 1 (abajo)
        X1 = [X1 dataMathematics.wall(j).p1(1)];
        X2 = [X2 dataMathematics.wall(j).p2(1)];
        Y1 = [Y1 dataMathematics.wall(j).p1(2)];
        Y2 = [Y2 dataMathematics.wall(j).p2(2)];
        Z1 = [Z1 dataMathematics.wall(j).p1(3)];
        Z2 = [Z2 dataMathematics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataMathematics.wall(j).p2(1)];
        X2 = [X2 dataMathematics.wall(j).p3(1)];
        Y1 = [Y1 dataMathematics.wall(j).p2(2)];
        Y2 = [Y2 dataMathematics.wall(j).p3(2)];
        Z1 = [Z1 dataMathematics.wall(j).p2(3)];
        Z2 = [Z2 dataMathematics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataMathematics.wall(j).p3(1)];
        X2 = [X2 dataMathematics.wall(j).p4(1)];
        Y1 = [Y1 dataMathematics.wall(j).p3(2)];
        Y2 = [Y2 dataMathematics.wall(j).p4(2)];
        Z1 = [Z1 dataMathematics.wall(j).p3(3)];
        Z2 = [Z2 dataMathematics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataMathematics.wall(j).p4(1)];
        X2 = [X2 dataMathematics.wall(j).p1(1)];
        Y1 = [Y1 dataMathematics.wall(j).p4(2)];
        Y2 = [Y2 dataMathematics.wall(j).p1(2)];
        Z1 = [Z1 dataMathematics.wall(j).p4(3)];
        Z2 = [Z2 dataMathematics.wall(j).p1(3)];    
    end

        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','r','MarkerSize',30);
        hold on


    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=dataMathematics.finPrimeraPlanta+1:1:dataMathematics.finSegundaPlanta 
        % Lnea 1 (abajo)
        X1 = [X1 dataMathematics.wall(j).p1(1)];
        X2 = [X2 dataMathematics.wall(j).p2(1)];
        Y1 = [Y1 dataMathematics.wall(j).p1(2)];
        Y2 = [Y2 dataMathematics.wall(j).p2(2)];
        Z1 = [Z1 dataMathematics.wall(j).p1(3)];
        Z2 = [Z2 dataMathematics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataMathematics.wall(j).p2(1)];
        X2 = [X2 dataMathematics.wall(j).p3(1)];
        Y1 = [Y1 dataMathematics.wall(j).p2(2)];
        Y2 = [Y2 dataMathematics.wall(j).p3(2)];
        Z1 = [Z1 dataMathematics.wall(j).p2(3)];
        Z2 = [Z2 dataMathematics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataMathematics.wall(j).p3(1)];
        X2 = [X2 dataMathematics.wall(j).p4(1)];
        Y1 = [Y1 dataMathematics.wall(j).p3(2)];
        Y2 = [Y2 dataMathematics.wall(j).p4(2)];
        Z1 = [Z1 dataMathematics.wall(j).p3(3)];
        Z2 = [Z2 dataMathematics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataMathematics.wall(j).p4(1)];
        X2 = [X2 dataMathematics.wall(j).p1(1)];
        Y1 = [Y1 dataMathematics.wall(j).p4(2)];
        Y2 = [Y2 dataMathematics.wall(j).p1(2)];
        Z1 = [Z1 dataMathematics.wall(j).p4(3)];
        Z2 = [Z2 dataMathematics.wall(j).p1(3)];    
    end

        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','g','MarkerSize',30);
        hold on
        
      X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=dataMathematics.finSegundaPlanta +1:1:dataMathematics.fincosas 
        % Lnea 1 (abajo)
        X1 = [X1 dataMathematics.wall(j).p1(1)];
        X2 = [X2 dataMathematics.wall(j).p2(1)];
        Y1 = [Y1 dataMathematics.wall(j).p1(2)];
        Y2 = [Y2 dataMathematics.wall(j).p2(2)];
        Z1 = [Z1 dataMathematics.wall(j).p1(3)];
        Z2 = [Z2 dataMathematics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataMathematics.wall(j).p2(1)];
        X2 = [X2 dataMathematics.wall(j).p3(1)];
        Y1 = [Y1 dataMathematics.wall(j).p2(2)];
        Y2 = [Y2 dataMathematics.wall(j).p3(2)];
        Z1 = [Z1 dataMathematics.wall(j).p2(3)];
        Z2 = [Z2 dataMathematics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataMathematics.wall(j).p3(1)];
        X2 = [X2 dataMathematics.wall(j).p4(1)];
        Y1 = [Y1 dataMathematics.wall(j).p3(2)];
        Y2 = [Y2 dataMathematics.wall(j).p4(2)];
        Z1 = [Z1 dataMathematics.wall(j).p3(3)];
        Z2 = [Z2 dataMathematics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataMathematics.wall(j).p4(1)];
        X2 = [X2 dataMathematics.wall(j).p1(1)];
        Y1 = [Y1 dataMathematics.wall(j).p4(2)];
        Y2 = [Y2 dataMathematics.wall(j).p1(2)];
        Z1 = [Z1 dataMathematics.wall(j).p4(3)];
        Z2 = [Z2 dataMathematics.wall(j).p1(3)];    
    end

    plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','k','MarkerSize',30);
    hold on
    
    hold on
    plot3(dataMathematics.pE1(:,1),dataMathematics.pE1(:,2),dataMathematics.pE1(:,3),'color','K','MarkerSize',10);
    hold off
  
elseif(planta == 0)
    
    % PintdataMathematics.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];


    for j=1:1:dataMathematics.finPlantaBaja 
        % Lnea 1 (abajo)
        X1 = [X1 dataMathematics.wall(j).p1(1)];
        X2 = [X2 dataMathematics.wall(j).p2(1)];
        Y1 = [Y1 dataMathematics.wall(j).p1(2)];
        Y2 = [Y2 dataMathematics.wall(j).p2(2)];
        Z1 = [Z1 dataMathematics.wall(j).p1(3)];
        Z2 = [Z2 dataMathematics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataMathematics.wall(j).p2(1)];
        X2 = [X2 dataMathematics.wall(j).p3(1)];
        Y1 = [Y1 dataMathematics.wall(j).p2(2)];
        Y2 = [Y2 dataMathematics.wall(j).p3(2)];
        Z1 = [Z1 dataMathematics.wall(j).p2(3)];
        Z2 = [Z2 dataMathematics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataMathematics.wall(j).p3(1)];
        X2 = [X2 dataMathematics.wall(j).p4(1)];
        Y1 = [Y1 dataMathematics.wall(j).p3(2)];
        Y2 = [Y2 dataMathematics.wall(j).p4(2)];
        Z1 = [Z1 dataMathematics.wall(j).p3(3)];
        Z2 = [Z2 dataMathematics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataMathematics.wall(j).p4(1)];
        X2 = [X2 dataMathematics.wall(j).p1(1)];
        Y1 = [Y1 dataMathematics.wall(j).p4(2)];
        Y2 = [Y2 dataMathematics.wall(j).p1(2)];
        Z1 = [Z1 dataMathematics.wall(j).p4(3)];
        Z2 = [Z2 dataMathematics.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on
        
        
    elseif(planta == 0)
    
    % PintdataMathematics.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];


    for j=1:finPlantaBaja+1:dataMathematics.finPrimeraPlanta 
        % Lnea 1 (abajo)
        X1 = [X1 dataMathematics.wall(j).p1(1)];
        X2 = [X2 dataMathematics.wall(j).p2(1)];
        Y1 = [Y1 dataMathematics.wall(j).p1(2)];
        Y2 = [Y2 dataMathematics.wall(j).p2(2)];
        Z1 = [Z1 dataMathematics.wall(j).p1(3)];
        Z2 = [Z2 dataMathematics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataMathematics.wall(j).p2(1)];
        X2 = [X2 dataMathematics.wall(j).p3(1)];
        Y1 = [Y1 dataMathematics.wall(j).p2(2)];
        Y2 = [Y2 dataMathematics.wall(j).p3(2)];
        Z1 = [Z1 dataMathematics.wall(j).p2(3)];
        Z2 = [Z2 dataMathematics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataMathematics.wall(j).p3(1)];
        X2 = [X2 dataMathematics.wall(j).p4(1)];
        Y1 = [Y1 dataMathematics.wall(j).p3(2)];
        Y2 = [Y2 dataMathematics.wall(j).p4(2)];
        Z1 = [Z1 dataMathematics.wall(j).p3(3)];
        Z2 = [Z2 dataMathematics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataMathematics.wall(j).p4(1)];
        X2 = [X2 dataMathematics.wall(j).p1(1)];
        Y1 = [Y1 dataMathematics.wall(j).p4(2)];
        Y2 = [Y2 dataMathematics.wall(j).p1(2)];
        Z1 = [Z1 dataMathematics.wall(j).p4(3)];
        Z2 = [Z2 dataMathematics.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on
        
    % PintdataMathematics.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];


    for j=1:1:dataMathematics.finPlantaBaja 
        % Lnea 1 (abajo)
        X1 = [X1 dataMathematics.wall(j).p1(1)];
        X2 = [X2 dataMathematics.wall(j).p2(1)];
        Y1 = [Y1 dataMathematics.wall(j).p1(2)];
        Y2 = [Y2 dataMathematics.wall(j).p2(2)];
        Z1 = [Z1 dataMathematics.wall(j).p1(3)];
        Z2 = [Z2 dataMathematics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataMathematics.wall(j).p2(1)];
        X2 = [X2 dataMathematics.wall(j).p3(1)];
        Y1 = [Y1 dataMathematics.wall(j).p2(2)];
        Y2 = [Y2 dataMathematics.wall(j).p3(2)];
        Z1 = [Z1 dataMathematics.wall(j).p2(3)];
        Z2 = [Z2 dataMathematics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataMathematics.wall(j).p3(1)];
        X2 = [X2 dataMathematics.wall(j).p4(1)];
        Y1 = [Y1 dataMathematics.wall(j).p3(2)];
        Y2 = [Y2 dataMathematics.wall(j).p4(2)];
        Z1 = [Z1 dataMathematics.wall(j).p3(3)];
        Z2 = [Z2 dataMathematics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataMathematics.wall(j).p4(1)];
        X2 = [X2 dataMathematics.wall(j).p1(1)];
        Y1 = [Y1 dataMathematics.wall(j).p4(2)];
        Y2 = [Y2 dataMathematics.wall(j).p1(2)];
        Z1 = [Z1 dataMathematics.wall(j).p4(3)];
        Z2 = [Z2 dataMathematics.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on
    
    % PintdataMathematics.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=1:1:dataMathematics.finPlantaBaja 
        % Lnea 1 (abajo)
        X1 = [X1 dataMathematics.wall(j).p1(1)];
        X2 = [X2 dataMathematics.wall(j).p2(1)];
        Y1 = [Y1 dataMathematics.wall(j).p1(2)];
        Y2 = [Y2 dataMathematics.wall(j).p2(2)];
        Z1 = [Z1 dataMathematics.wall(j).p1(3)];
        Z2 = [Z2 dataMathematics.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 dataMathematics.wall(j).p2(1)];
        X2 = [X2 dataMathematics.wall(j).p3(1)];
        Y1 = [Y1 dataMathematics.wall(j).p2(2)];
        Y2 = [Y2 dataMathematics.wall(j).p3(2)];
        Z1 = [Z1 dataMathematics.wall(j).p2(3)];
        Z2 = [Z2 dataMathematics.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 dataMathematics.wall(j).p3(1)];
        X2 = [X2 dataMathematics.wall(j).p4(1)];
        Y1 = [Y1 dataMathematics.wall(j).p3(2)];
        Y2 = [Y2 dataMathematics.wall(j).p4(2)];
        Z1 = [Z1 dataMathematics.wall(j).p3(3)];
        Z2 = [Z2 dataMathematics.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 dataMathematics.wall(j).p4(1)];
        X2 = [X2 dataMathematics.wall(j).p1(1)];
        Y1 = [Y1 dataMathematics.wall(j).p4(2)];
        Y2 = [Y2 dataMathematics.wall(j).p1(2)];
        Z1 = [Z1 dataMathematics.wall(j).p4(3)];
        Z2 = [Z2 dataMathematics.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on
        
        xlabel('West - East (m)')
        ylabel('South - North (m)')
        zlabel('Height (m)')
        hold off
end       

end       


